/*
 * Decompiled with CFR 0.152.
 */
package com.android.core.utils.params;

import com.android.core.domain.model.RequestData;
import com.android.core.utils.params.QueryParamTypes;
import com.android.core.utils.params.QueryParams;
import com.core.util.filter.Filter;
import com.utility.ConvertStr;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.lang.NonNull;

public class AndroidFilter
implements Filter {
    private final RequestData request;
    private final QueryParamTypes type;

    @NonNull
    public String getFilter() {
        if (this.type.equals((Object)QueryParamTypes.NO_QUERY)) {
            return "";
        }
        QueryParams queryParams = this.type.getInstance();
        for (String currentParam : this.request.getParamMap().keySet()) {
            if (this.isPagingParam(currentParam)) continue;
            String paramValue = this.request.getParamValue(currentParam);
            queryParams.addParam(currentParam, paramValue);
        }
        return ConvertStr.nullSafeString((String)queryParams.makeWhere());
    }

    public Map<String, String> makeUserParamMap(boolean lowerCaseParamNames) {
        ConcurrentHashMap<String, String> userGivenParamMap = new ConcurrentHashMap<String, String>();
        for (String nextParam : this.request.getParamMap().keySet()) {
            String paramValue;
            if (this.isPagingParam(nextParam) || (paramValue = this.request.getParamValue(nextParam)) == null) continue;
            userGivenParamMap.put(lowerCaseParamNames ? nextParam.toLowerCase() : nextParam, paramValue);
        }
        return userGivenParamMap;
    }

    @NonNull
    public String getFilterWithPrecedingWhere() {
        String sqlWhere = this.getFilter();
        return sqlWhere.isEmpty() ? "" : " WHERE " + sqlWhere;
    }

    public AndroidFilter(RequestData request, QueryParamTypes type) {
        this.request = request;
        this.type = type;
    }
}

